% Model of a non-steady state non-isothermal plug flow reactor - Gas phase

% Function file

% For more information, see:

% A. De Visscher 
% Lecture Notes in Chemical Engineering Kinetics and Chemical Reactor Design
% Createspace (2013) 

% (C) Alex De Visscher (2013)

% ---------------------------

function dydt = f(t,y,Ak2,Ek2,BKE,HKE,BKH,HKH,BKA,HKA,ME,MH,MA,D,OMEGA,mu,Tc,dp,rhob,phi,U,CpE,CpH,CpA,DH400,Cpcm,usin,deltaV)

dydt = zeros(404,1);     % Allocate space for the right-hand sides of the DEs
t
us(1) = usin;
R = 8.314472;

for j = 1:101
    cE(j) = y(j);
    cH(j) = y(101+j);
    cA(j) = y(202+j);
    Temp(j) = y(303+j);
    ctot(j) = cE(j) + cH(j) + cA(j);
    p(j) = ctot(j)*R*Temp(j);
    pE(j) = p(j)*cE(j)/ctot(j);
    pH(j) = p(j)*cH(j)/ctot(j);
    if pH(j) < 0
        pH(j) = 0;
    end
    pA(j) = p(j)*cA(j)/ctot(j);
    rho(j) = cE(j)*ME + cH(j)*MH + cA(j)*MA;
    k2 = Ak2*exp(-Ek2/(R*Temp(j)));
    KE = BKE*exp(HKE/(R*Temp(j)));
    KH = BKH*exp(HKH/(R*Temp(j)));
    KA = BKA*exp(HKA/(R*Temp(j)));
    r(j) = k2*pE(j)/1e5*sqrt(pH(j)/1e5)/(1 + KE*pE(j)/1e5 + sqrt(KH*pH(j)/1e5) + KA*pA(j)/1e5)^2; % Reaction rate
    rE(j) = -r(j);
    rH(j) = -r(j);
    rA(j) = r(j);
    dCp = CpA - CpH - CpE;
    deltaH(j) = DH400 + dCp*(Temp(j) - 673.15);
    Cpsum(j) = cE(j)*CpE + cH(j)*CpH + cA(j)*CpA;
end

for j = 2:101
    dpdV(j) = (p(j) - p(j-1))/deltaV;
    dctotdV(j) = (ctot(j) - ctot(j-1))/deltaV;
    G(j) = (1/3.5)*(-150*(1-phi)*mu/dp + sqrt((150*(1-phi)*mu/dp)^2 - 7*dpdV(j)*rho(j)*OMEGA*dp*phi^3/(1-phi)));
    us(j) = G(j)/rho(j);
%    us(2) = usin;
    dusdV(j-1) = (us(j) - us(j-1))/deltaV;
    dTdV(j) = (Temp(j) - Temp(j-1))/deltaV;
    dcEdV(j) = (cE(j) - cE(j-1))/deltaV;
    dcHdV(j) = (cH(j) - cH(j-1))/deltaV;
    dcAdV(j) = (cA(j) - cA(j-1))/deltaV;
    dcEusdV(j) = (cE(j)*us(j) - cE(j-1)*us(j-1))/deltaV;
    dcHusdV(j) = (cH(j)*us(j) - cH(j-1)*us(j-1))/deltaV;
    dcAusdV(j) = (cA(j)*us(j) - cA(j-1)*us(j-1))/deltaV;
end
d2usdV2 = (dusdV(100) - dusdV(99))/deltaV;
dusdV(101) = dusdV(100) + d2usdV2*deltaV;

dydt(1) = 0;
dydt(102) = 0;
dydt(203) = 0;
dydt(304) = 0;
for j = 2:101
%    us(j) = abs(us(j));
    dydt(j) = (1/phi)*(-OMEGA*us(j)*dcEdV(j) - OMEGA*cE(j)*dusdV(j) + rhob*rE(j));
    dydt(101+j) = (1/phi)*(-OMEGA*us(j)*dcHdV(j) - OMEGA*cH(j)*dusdV(j) + rhob*rH(j));
    dydt(202+j) = (1/phi)*(-OMEGA*us(j)*dcAdV(j) - OMEGA*cA(j)*dusdV(j) + rhob*rA(j));
    dydt(303+j) = (1/(phi*Cpsum(j) + rhob*Cpcm))*(-r(j)*deltaH(j)*rhob - us(j)*OMEGA*Cpsum(j)*dTdV(j) + U*(Tc - Temp(j))*4/D);
end
dydt(101) = -dydt(202) - dydt(303) - (ctot(101)/Temp(101))*dydt(404);
